-- Library and Use statements for IEEE packages
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity top is
port(
ClkA,ClkB   : in  std_logic;
A,B   : in std_logic;
out1, out2 : out std_logic
);

end top;

architecture behave of top is

Component CDC_sync is
port(
RClk   : in  std_logic;
A : in std_logic;
B : out std_logic
);
end component; 

signal A_Sig, B_sig: std_logic;
signal A_Sig1, B_sig1 : std_logic;


begin

process(clkA)
begin
if rising_edge(clkA) then
	A_sig <= A ;
	out1 <= A_sig and B_sig1; 
end if;
end process;

MyCDC01 : CDC_sync 
port map(
RClk  => CLKB,
A => A_sig,
B => A_sig1
);

process(clkB)
begin
if rising_edge(clkB) then
	B_sig <= B ;
	out2 <= B_sig and A_sig1; 

end if;
end process;

MyCDC02 : CDC_sync 
port map(
RClk  => CLKA,
A => B_sig,
B => B_sig1
);


end behave;